bdcd <-
function(x, y, weights, nvar, lambda, start, intercept,
xtvfun, xvfun, xtxvfun, xjfun, control)  {
	
	if (length(lambda)==1) lambda=c(ifelse(intercept,0,lambda),rep(lambda,nvar-1))
	else if (intercept && length(lambda) != nvar) lambda=c(0,lambda)
	
	covyx <- xtvfun(x,y,weights)
	beta <- start

	maxit <- .ifset(control$maxitcd,ifset(control$maxit,100)) 
	epsilon <- .ifset(control$epsilon, 1e-8)
	
	for (iter in 1:maxit) {
		betaold <- beta
		for (j in (ifelse(intercept,2,1)):nvar) {
	        	if (control$trace && j %% 1000 == 0) 
				cat("Variable = ", j, " Iterations - ", iter, "\n", sep = "")
	
			xj <- xjfun(x,c(j))
			if (is.na(xj[1])) next
			covxxj <- xtvfun(x, xj, weights)

			val <- (covyx[j]-sum(covxxj*beta))
			if (covxxj[j] != 0)
				beta[j] <- (.bdsoftthreshold(val+beta[j]*covxxj[j],lambda[j]))/covxxj[j]
			else {
				warning("variance 0 for observation ", j, " in iteration ", iter)
			}
        	}
        	dev <- sum((betaold-beta)^2)
	        if (control$trace) 
			cat("Delta = ", dev, " Iterations - ", iter, "\n", sep = "")

		if (dev < epsilon) break;
	}
	
	res <- list(coefficients=beta, itercd=iter, lambda=lambda,delta=dev)
	
	return(res)
}
