bdcg <-
function(x, w, b, c0=0, xtvfun, xvfun, xtxvfun, xtxfun, control=list())  {
	n <- length(w)
	
	if (!is.null(xtxfun)) {h <- xtxfun(x,w); matxp <- 2*xvfun(h,c0)}
	else if (!is.null(xtxvfun)) matxp <- 2*xtxvfun(x,c0,w)
	else matxp <- 2*xtvfun(x,xvfun(x, c0),w)
	
	gk <- (b + matxp)
	
	dk <- -gk
	ck <- c0
	k <- 0
	
	maxit <- .ifset(control$maxitcg,ifset(control$maxit,100)) 
	epsilon <- .ifset(control$epsilon, 1e-08)
	trace <- .ifset(control$trace, F)
	conv=F

	while (k < maxit)
	{
		if (!is.null(xtxfun)) matdp <- 2*xvfun(h,dk)
		else if (!is.null(xtxvfun)) matdp <- 2*xtxvfun(x,dk,w)
		else matdp <- 2*xtvfun(x,xvfun(x, dk),w)
		
		alphak <- ((t(gk) %*% gk)/(t(dk) %*% matdp))[1]

		cn <- ck+alphak * dk
		dev <- sum(abs(alphak * dk))
		if (trace) 
			cat("Delta = ", dev, " Iterations - ", k, "\n", sep = "")

		if (dev < epsilon) {conv=T;break;}
		
		matxn <- matxp + alphak*matdp
		gn <- b + matxn

		betak <- ((t(gn) %*% gn)/(t(gk) %*% gk))[1]
		dn <- -gn+betak*dk
		k <- k+1;dk <- dn;gk <- gn;ck <- cn;matxp <- matxn
	}
	
	return(list(coefficients=cn,iter=k,delta=dev,converged=conv))	
}
