.bdglm.default.xj <-
function(x,ind) {
	if (ind[1] <= ncol(x)) return (x[,ind[1]])
	return (c(NA))	
}
.bdglm.default.xj.int <-
function(x,ind) {
	if (ind[1]==1) return(rep(1,nrow(x)))
	if (ind[1] <= ncol(x)+1) return(x[,ind[1]-1])
	return (c(NA))	
}
.bdglm.default.xtx <-
function(x,weights) {
	return(t(x) %*% (weights*x) )
}
.bdglm.default.xtx.int <-
function(x,weights) {
	x1 <- cbind(1,x)
	return(t(x1) %*% (weights*x1) )
}
.bdglm.default.xtxv <-
function(x,b,weights) {
	return(t(x) %*% (weights*x) %*% b)
}
.bdglm.default.xtxv.int <-
function(x,b,weights) {
	x1 <- cbind(1,x)
	return((t(x1)) %*% (weights*x1) %*% b)
}
.bdglm.default.xty <-
function(x,y,weights) {
	return(t(x) %*% (weights*y))
}
.bdglm.default.xty.int <-
function(x,y,weights) {
	wy=weights*y
	return(c(sum(wy),t(x) %*% wy))
}
.bdglm.default.xv <-
function(x,b) {
	return ((x) %*% b)
}
.bdglm.default.xv.int <-
function(x, b ) {
	if (ncol(x) == length(b)) return (x %*% b)
	return ((x %*% b[-1])+b[1])
}
.bdsoftthreshold <-
function(z,gamma)
{
	if (z > 0 && gamma < abs(z)) return (z-gamma)
	if (z < 0 && gamma < abs(z)) return (z+gamma)
	return (0)
}
.bdcov <-
function(object,xtxfun) {
	if (!is.function(xtxfun)) stop("invalid function 'xtxfun'")

	tryCatch ({
		var <- xtxfun(object$x,object$weights)
		bdqr <- chol(var)
		p1 <- 1:object$rank
		coef.p <- object$coefficients
		covmat.unscaled <- chol2inv(bdqr)
		#covmat <- dispersion * covmat.unscales
		covmat <- covmat.unscaled

		var.cf <- diag(covmat)
		s.err <- sqrt(var.cf)
		tvalue <- coef.p/s.err
		dn <- c("Estimate", "Std. Error")
		#pvalue <- 2 * pnorm(-abs(tvalue), object$df.residual)
		pvalue <- 2 * pnorm(-abs(tvalue))
		coef.table <- cbind(coef.p, s.err, tvalue, pvalue)
		dimnames(coef.table) <- list(names(coef.p), c(dn, "z value", "Pr(>|z|)"))
		return(list(cov.unscaled=covmat.unscaled,coefficients=coef.table))
	},
	error=function(cond) {
		warning(cond)
	},
	warning=function(cond) {
		warning(cond)
	})

	return(list())
}

.ifset <-
function(val,default) if(is.null(val)) return(default) else return(val)
.iftrue <-
function(cond,iftrue,iffalse) if(cond) return(iftrue) else return(iffalse)
