bdglm.control <-
function (epsilon = 1e-08, maxit = 20, trace = FALSE, maxitcg = 20, maxitcd=10, maxitgb=2, threshold=1e-08) 
{
    if (!is.numeric(epsilon) || epsilon <= 0) 
        stop("value of 'epsilon' must be > 0")
    if (!is.numeric(maxit) || maxit <= 0) 
        stop("maximum number of iterations for irls must be > 0")
    if (!is.numeric(maxitcg) || maxitcg <= 0) 
        stop("maximum number of iterations for conjugate gradient must be > 0")
    if (!is.numeric(maxitcd) || maxitcd <= 0) 
        stop("maximum number of iterations for coordinate descent must be > 0")
    if (!is.numeric(maxitgb) || maxitgb <= 0) 
        stop("maximum number of iterations for group bridge must be > 0")
    if (!is.numeric(threshold) || threshold < 0) 
        stop("value of 'epsilon' must be >= 0")
        
    list(epsilon = epsilon, maxit = maxit, trace = trace, maxitcg=maxitcg, maxitcd=maxitcd, maxitgb=maxitgb, threshold=1e-08)
}
