bdglm.fit <-
function(x,y,family=binomial("logit"),weights=NULL,
	start,etastart=NULL,mustart=NULL,
	intercept=T, matfun=list(), minfun="bdcg", control=list(...), ...)  {
		
	call=match.call()
	#print(call)
	
	if (is.null(x) || is.null(y)) 
		stop("x and y are required")

	if (!is.numeric(y)) 
		stop ("y have to be numeric")

	if (length(matfun) == 0) {
		xtvfun=.iftrue(intercept,.bdglm.default.xty.int,.bdglm.default.xty)
		xvfun=.iftrue(intercept,.bdglm.default.xv.int,.bdglm.default.xv)
		xtxvfun=.iftrue(intercept,.bdglm.default.xtxv.int,.bdglm.default.xtxv)
		xtxfun=.iftrue(intercept,.bdglm.default.xtx.int,.bdglm.default.xtx)
	}
	else {
		xtvfun=matfun$xtvfun;xvfun=matfun$xvfun;xtxvfun=matfun$xtxvfun;
		xtxfun=matfun$xtxfun
	}

	if (!is.null(weights) && (!is.numeric(weights))) 
		stop ("weights have to be numeric")
	
	if (!is.null(weights) && (any(weights < 0))) 
		stop ("negative weights not allowed")

	if (is.character(family))
		family <- get(family, mode = "function", envir = parent.frame())

	if (is.function(family)) 
		family <- family()

	if (is.null(family$family)) {
		print(family)
		stop("'family' not recognized")
	}
    
	if (!is.character(minfun) && !is.function(minfun)) 
		stop("invalid 'minfun' argument")
        
	f <- .iftrue(intercept,as.formula(y~x),as.formula(y~x-1))
	mt <- terms(f)

	control=do.call("bdglm.control",control)
        
	fit=bdglm.irls(x,y,family,weights,
		start=start,etastart=etastart,mustart=mustart, intercept=intercept,
		xtvfun=xtvfun,xvfun=xvfun,xtxvfun=xtxvfun,xtxfun=xtxfun,
		minfun=minfun,control=control)
	
	res=c(fit,list(call=call,x=x,y=y,family=family,terms=mt, formula=f,
		xtvfun=xtvfun,xvfun=xvfun,xtxvfun=xtxvfun,xtxfun=xtxfun))
	class(res)=c("bdglm","glm")
	return(res)
}
