bdglm.fit.groupbridge <-
function(x, y, family, weights=NULL, nvar, 
	start, etastart=NULL, mustart=NULL, intercept=T,
	amat, cvec, gamma=0.5, tau, 
	matfun=list(), minfun="bdcg", hasmle=F, control=list(...), ...)  {

	call=match.call()
	
	if (is.null(x) || is.null(y)) 
		stop("x and y are required")

	if (!is.numeric(y)) 
		stop ("y have to be numeric")

	if (is.na(nvar) || is.null(nvar)) {
		if (length(start) > 0) nvar = length(start)
		else if (length(dim(x)) < 2) stop ("unknown number of parameters")
		else nvar = dim(x)[2]
	}

	if (length(matfun) == 0) {
		xtvfun=.iftrue(intercept,.bdglm.default.xty.int,.bdglm.default.xty)
		xvfun=.iftrue(intercept,.bdglm.default.xv.int,.bdglm.default.xv)
		xtxvfun=.iftrue(intercept,.bdglm.default.xtxv.int,.bdglm.default.xtxv)
		xtxfun=.iftrue(intercept,.bdglm.default.xtx.int,.bdglm.default.xtx)
		xjfun=.iftrue(intercept,.bdglm.default.xj.int,.bdglm.default.xj)
	}
	else {
		xtvfun=matfun$xtvfun;xvfun=matfun$xvfun;xtxvfun=matfun$xtxvfun;
		xtxfun=matfun$xtxfun;xjfun=matfun$xjfun
	}
	
	nobs <- NROW(y)
	if (is.null(weights)) weights <- rep(1,nobs)  

	control=do.call("bdglm.control",control)

	# verify gb parameters: amat, c, g, taun
	if (ncol(amat) != nvar-ifelse(intercept,1,0)) 
		stop ("number of columns of amat should match nvar-intercept")
	if (length(cvec) != nrow(amat)) 
		stop ("number of rows of amat should match cvec")

	
	# call bdglm.irls to compute mle
	if (hasmle) {
		mle <- start
		z <- eta <- xvfun(x, start)
		mu <- family$linkinv(z)
		var <- family$variance(mu)
		dmu.deta <- family$mu.eta(eta)
		w <- weights*(dmu.deta^2)/var
	} else {
		res = bdglm.irls (x,y,family,weights=weights,start=start,
			etastart=etastart,mustart=mustart, intercept=intercept, 
			xtvfun=xtvfun, xvfun=xvfun, xtxvfun=xtxvfun, xtxfun=xtxfun, 
			minfun=minfun, control=control)		
		mle <- res$coefficients
		w <- res$weights
		z <- res$linear.predictors
	}
	
	if (is.na(mle) || is.null(mle)) stop ("mle computation failed")
	
	if (length(dim(mle)) > 1) mle <- mle[,1]

	if (intercept) {
		mle0 <- mle[1]
		z = z - mle[1]
		mle[1] <- 0
	}
	
	maxit <- .ifset(control$maxitgb,2)
	
	J <- dim(amat)[1]
	p <- dim(amat)[2]
	beta <- mle
	
	for (iter in 1:maxit) {
		
		theta <- sapply(1:J, FUN= function(j) {
			cvec[j]*((1-gamma)/(tau*gamma))^(gamma)*sum((abs(beta[amat[j,]]))^(gamma))})

		lambda <- sapply(1:p, FUN=function(i) { 
 			sum( (theta[amat[,i]])^(1-1/gamma) * (cvec[amat[,i]])^(1/gamma) ) } )
  	  
		fit <- bdcd(x, z, weights=w, nvar=nvar, lambda=lambda, 
			start=beta, intercept=intercept,
			xtvfun=xtvfun, xvfun=xvfun, xtxvfun=xtxvfun, xjfun=xjfun, control=control)
	
		beta <- fit$coefficients
	  
	}
	
	if (intercept) {
		fit$coefficients[1]=mle0
	}
   
	validobs <- nobs - sum(weights == 0)
	rank <- sum(abs(fit$coefficients) > control$threshold)
	wtdmu <- if (intercept) sum(weights * y)/sum(weights) else family$linkinv(0)
		
	eta <- xvfun(x, fit$coefficients)
	if (length(dim(eta))>1) eta <- eta[,1]
	mu <- family$linkinv(eta)

	dev <- sum(family$dev.resids(y,mu,weights))
	nulldev <- sum(family$dev.resids(y, wtdmu, weights))

	resdf <- validobs - rank
	nulldf <- validobs - as.integer(intercept)

	residuals=(y-mu)/family$mu.eta(eta)
	names(residuals)=names(y)
	xnames <- dimnames(x)[[2]]
	if(is.null(xnames)) 
		xnames=rownames(.iftrue(intercept,mle[-1],mle),do.NULL=F,prefix="x")
	if (intercept) xnames=c("Intercept",xnames)
	names(fit$coefficients)=xnames

	aic.model <- family$aic(y, nobs, mu, weights, dev) + 2 * rank
	
	fit$deviance=dev;fit$prior.weights=weights;fit$fitted.values=mu
	fit$residuals=residuals;fit$rank=rank;fit$linear.predictors=eta
	fit$df.null=nulldf;fit$df.residual=resdf;fit$null.deviance=nulldev
	fit$aic=aic.model
	
	res=c(fit,list(call=call,x=x,y=y,family=family,tau=tau,iter=iter,
		xtvfun=xtvfun,xvfun=xvfun,xtxvfun=xtxvfun,xjfun=xjfun))
	class(res)=c("bdglm","glm")
	return(res)
}
