bdglm.fit.lasso <-
function(x, y, family, weights=NULL, nvar=NULL, lambda=NULL, 
	start, etastart=NULL, mustart=NULL, intercept=T,
	matfun=list(), minfun="bdcg", hasmle=F, control=list(...), ...)  {

	call=match.call()
	
	if (is.null(x) || is.null(y)) 
		stop("x and y are required")

	if (!is.numeric(y)) 
		stop ("y have to be numeric")

	if (is.null(nvar)) {
		if (length(start) > 0) nvar = length(start)
		else if (length(dim(x)) < 2) stop ("unknown number of parameters")
		else nvar = dim(x)[2]
	}
	
	control=do.call("bdglm.control",control)

	if (length(matfun) == 0) {
		xtvfun=.iftrue(intercept,.bdglm.default.xty.int,.bdglm.default.xty)
		xvfun=.iftrue(intercept,.bdglm.default.xv.int,.bdglm.default.xv)
		xtxvfun=.iftrue(intercept,.bdglm.default.xtxv.int,.bdglm.default.xtxv)
		xtxfun=.iftrue(intercept,.bdglm.default.xtx.int,.bdglm.default.xtx)
		xjfun=.iftrue(intercept,.bdglm.default.xj.int,.bdglm.default.xj)
	}
	else {
		xtvfun=matfun$xtvfun;xvfun=matfun$xvfun;xtxvfun=matfun$xtxvfun;
		xtxfun=matfun$xtxfun;xjfun=matfun$xjfun
	}
	
	nobs <- NROW(y)
	if (is.null(weights)) weights <- rep(1,nobs)  

	# first call bdglm.irls to compute mle
	if (hasmle) {
		fit <- list()
		mle <- start
		z <- eta <- xvfun(x, start)
		mu <- family$linkinv(z)
		var <- family$variance(mu)
		dmu.deta <- family$mu.eta(eta)
		w <- weights*(dmu.deta^2)/var
	} else {
		fit <- bdglm.irls (x,y,family,weights=weights,start=start,
			etastart=etastart,mustart=mustart, intercept=intercept, 
			xtvfun=xtvfun, xvfun=xvfun, xtxvfun=xtxvfun, xtxfun=xtxfun, 
			minfun=minfun, control=control)		
		mle <- fit$coefficients
		w <- fit$weights
		z <- fit$linear.predictors
	}

	if (is.na(mle) || is.null(mle)) stop ("error computing mle")
	
	if (is.null(lambda)) return(mle)

	if (!is.numeric(lambda)) stop ("penalty 'lambda' has to be numeric")

	if (any(lambda < 0)) stop ("negative penalty 'lambda' not allowed")
	
	if (length(dim(mle)) > 1) mle = mle[,1]
	
	if (intercept) {
		mle0 <- mle[1]
		z = z - mle[1]
		mle[1] <- 0
	}
	
	cdfit <- bdcd(x, z, weights=w, nvar=nvar, lambda=lambda, 
		start=mle, intercept=intercept,
		xtvfun=xtvfun, xvfun=xvfun, xtxvfun=xtxvfun, xjfun=xjfun, control=control)
	fit$coefficients=cdfit$coefficients
	if (intercept) {
		fit$coefficients[1]=mle0
	}

	validobs <- nobs - sum(weights == 0)
	rank <- sum(abs(fit$coefficients) > control$threshold)
	wtdmu <- if (intercept) sum(weights * y)/sum(weights) else family$linkinv(0)
		
	eta <- xvfun(x, fit$coefficients)
	if (length(dim(eta))>1) eta <- eta[,1]
	mu <- family$linkinv(eta)

	dev <- sum(family$dev.resids(y,mu,weights))
	nulldev <- sum(family$dev.resids(y, wtdmu, weights))

	resdf <- validobs - rank
	nulldf <- validobs - as.integer(intercept)

	residuals=(y-mu)/family$mu.eta(eta)
	names(residuals)=names(y)
	xnames <- dimnames(x)[[2]]
	if(is.null(xnames)) 
		xnames=rownames(.iftrue(intercept,mle[-1],mle),do.NULL=F,prefix="x")
	if (intercept) xnames=c("Intercept",xnames)
	names(fit$coefficients)=xnames

	aic.model <- family$aic(y, nobs, mu, weights, dev) + 2 * rank
	
	fit$deviance=dev;fit$prior.weights=weights;fit$fitted.values=mu
	fit$residuals=residuals;fit$rank=rank;fit$linear.predictors=eta
	fit$df.null=nulldf;fit$df.residual=resdf;fit$null.deviance=nulldev
	fit$aic=aic.model
	
	res=c(fit,list(call=call,x=x,y=y,family=family,
		xtvfun=xtvfun,xvfun=xvfun,xtxvfun=xtxvfun,xjfun=xjfun))
	class(res)=c("bdglm","glm")
	return(res)
}
