bdglm.irls <-
function(x, y, family, weights=rep(1, nobs), 
	start, etastart=NULL, mustart=NULL, 
	intercept, xtvfun, xvfun, xtxvfun, xtxfun, minfun, control)  {
	
	#print(match.call())

	nobs <- NROW(y)
	if (is.null(weights)) weights <- rep(1,nobs)  # reevaluate if maybe keeping null is more efficient

	mukeep <- mustart
	eval(family$initialize)
	if (!is.null(mukeep)) mustart <- mukeep

	{
	  eta <- if (!is.null(etastart)) { 
	  	etastart 
	  }
	  else if (is.null(start)) {
	  	xvfun(x,start)
	  }
	  else {
	  	family$linkfun(mustart)
	  }
	}
	
	mu <- family$linkinv(eta)
	beta <- start
	
	dev <- 0
	conv <- F
	
	maxit=.ifset(control$maxit,100)
	
	for (iter in 1L:maxit) {

		var <- family$variance(mu)
		if (any(is.na(var))) stop("NA's in variance")
		if (any(var <= 0)) stop("variance not positive")
		
		dmu.deta <- family$mu.eta(eta)
		
		z <- eta + (y-mu)/dmu.deta
		w <- weights*(dmu.deta^2)/var
		
		b <- -2*xtvfun(x, z, w)
		
		min <- eval(call(if(is.function(minfun)) "minfun" else minfun, 
			x, w, b, beta, xtvfun, xvfun, xtxvfun, xtxfun, control))
		
		beta <- min$coefficients
		if (length(dim(beta))>1) beta <- beta[,1]
		#print(beta)
		
		eta <- xvfun(x, beta)
		if (length(dim(eta))>1) eta <- eta[,1]
		
		mu <- family$linkinv(eta)
		
		devold <- dev
		dev <- sum(family$dev.resids(y,mu,weights))
		
		if (control$trace) 
			cat("Deviance = ", dev, " Iterations - ", iter, "\n", sep = "")
          
		if (abs(dev - devold)/(0.1 + abs(dev)) < control$epsilon) {
			conv <- TRUE
			break
		}
	}

	validobs <- nobs - sum(weights == 0)
	rank <- length(beta)
	wtdmu <- if (intercept) sum(weights * y)/sum(weights) else family$linkinv(0)

	nulldev <- sum(family$dev.resids(y, wtdmu, weights))
	nulldf <- validobs - as.integer(intercept)
	resdf <- validobs - rank

	residuals=(y-mu)/family$mu.eta(eta)
	names(residuals)=names(y)
	xnames <- dimnames(x)[[2]]
	if(is.null(xnames)) 
		xnames=rownames(.iftrue(intercept,beta[-1],beta),do.NULL=F,prefix="x")
	if (intercept) xnames=c("Intercept",xnames)
	names(beta)=xnames

	aic.model <- family$aic(y, nobs, mu, weights, dev) + 2 * rank
	
	res=list(coefficients=beta,conv=conv,deviance=dev,iter=iter,prior.weights=weights,
		weights=w, fitted.values=mu, residuals=residuals, rank=rank, linear.predictors = eta,
		df.null=nulldf, df.residual=resdf, null.deviance=nulldev, aic = aic.model, n=nobs)
	return (res)
}
