predict.bdglm <-
function(object,newx=NULL,type=c("link","response"), weights=NULL,
	control=list(...), ...) {
	
	xvfun <- object$xvfun
	if (!is.function(xvfun)) stop("Invalid object")
	
	if (is.null(weights)) { 
		if (is.matrix(newx)) weights=rep(1,dim(newx)[1])
		else warning("weights not specified, NULL used")
	}
	
	eta <- xvfun(newx,object$coefficients)
	
	if(type=="link") return(eta)
	
	if (type=="response") {
		mu=object$family$linkinv(eta)
		return(mu)
	}
	stop("unsupported type '",type,"'")
}
