print.summary.bdglm <-
function(object) {
	cat("Call:\n")
	print(object$call)
	cat("\n")

	cat("Devicance Residuals:\n")
	drs=summary(object$deviance.resid)
	ldrs=list(Min=drs[[1]],"1Q"=drs[[2]],Median=drs[[3]],"3Q"=drs[[5]],Max=drs[[6]])
	class(ldrs)=c("summaryDefault","table")
	print(ldrs)
	cat("\n")

	cat("Coefficients:\n")
	if (is.null(object$lambda) && !is.null(object$stddev)) {
		coefs=object$stddev
		class(coefs)=c("summaryDefault","table")
		print(coefs)

		cat("\n")
	}
	else {
		coefs=object$coefficients
		class(coefs)=c("summaryDefault","table")
		print(coefs)
		cat("\n")
	}
	
	if(!is.null(object$lambda)) {
	  cat("Penalty:\n")
	  coefs=object$lambda
	  class(coefs)=c("summaryDefault","table")
	  print(coefs)
	  cat("\n")
	}

	cat("    Null deviance: ")
	cat(sprintf("%.3f",object$null.deviance))
	cat(" on ")
	cat(object$df.null)
	cat(" degrees of freedom")
	cat("\n")
	cat("Residual deviance: ")
	cat(sprintf("%.3f",object$deviance))
	cat(" on ")
	cat(object$df.residual)
	cat(" degrees of freedom")
	cat("\n")
	cat("AIC: ")
	cat(object$aic)
	cat("\n")
}
