summary.bdglm <-
function(object, dispersion=NULL) {

	keep <- match(c("call", "family", "coefficients", "deviance", "aic", 
        "df.residual", "null.deviance", "df.null", 
        "iter"), names(object), 0L)

	dispersion=1

	if (is.null(object$lambda) && !is.null(object$xtxfun)) {
		cov=.bdcov(object,object$xtxfun)
		prop <- c(object[keep],list(deviance.resid = residuals(object, type = "deviance"),
			dispersion=dispersion, stddev=cov$coefficients, cov.unscaled=cov$cov.unscaled))
	}
	else {
		prop <- c(object[keep],list(deviance.resid = residuals(object, type = "deviance"),
		    	dispersion=dispersion))
	}
      
	class(prop) <- "summary.bdglm"
    
	return(prop)
}
