\name{bdcd}
\alias{bdcd}
\title{Execute \code{coordinate descent} method.}
\description{ 
Minimizes weighted least squares estimate of a coefficient vector \eqn{alpha} with an \eqn{L_1} penalty vector \eqn{\lambda}.  
}
\usage{
bdcd(x, y, weights, nvar, lambda, start, intercept, xtvfun, xvfun, xtxvfun, xjfun, control)
}
\arguments{
  \item{x}{
	data object, can be a matrix, or a filename in a distributed filesystem.  
	It is never interpreted, but passed to matrix-vector operations.  
  }
  \item{y}{
	response vector. Expected to contain numerical binary data.  
	}
  \item{family}{ 
	glm family defining the type of data and link function. 
	Follows the standard established by \code{\link{glm}}. 
	(See \code{\link{family}} for family functions).  
	}
  \item{weights}{
	vector of weights, optional. 
	If set, expected to contain numerical, non-negative data.  
	}
  \item{nvar}{
	number of parameters in the model. Required if the number of parameteres 
	cannot be derived from \code{start} or \code{lambda}. 
	If specified, it should include intercept, if intercept is in the model.  
	}
  \item{lambda}{
	a penalty vector. If of length one, the same penalty is assumed for each parameter, 
	and 0 for the intercept.  If longer than one, it has to match the number of parameters in the model. 
	All penalties have to be numerical and non-negative.  
	}
  \item{start}{
	starting values for the optimization problem. Optional, defaults to 0. 
	The length of the starting vector is assumed to specify the number of parameters in the model.  
	}
  \item{intercept}{
	include the intercept in the model.  
	}
  \item{xtvfun}{
	Function executing \eqn{X^TWv}, where x, w and v are passed as arguments.
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a vector.  
	}
  \item{xvfun}{
	Function executing \eqn{Xv}, where x and v are passed as arguments.
	and \code{X} is represented by \code{x}.
	The result is returned as a vector.  
	}
  \item{xtxvfun}{
	Function executing \eqn{X^TWXv}, where x, w and v are passed as arguments.
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a vector.  
	}
  \item{xjfun}{
	Function executing \eqn{X[j]}, where x and j are passed as arguments. 
	\code{X} is represented by \code{x}. The result is returned as a vector.  
	}
  \item{minfun}{
	The method to be used to perform \eqn{L_2} minimization executed in each step 
	of \code{iteratively reweighted least squares}.
	Defaults to conjugate-gradient method \code{\link{bdcg}}.  
	}
  \item{hasmle}{
	if set to \code{True} the start parameter is assumed to represent  mle and mle calculation is skipped.  
	}
  \item{control}{
	a list of control parameters, epsilon, maxit, etc. See \code{\link{bdglm.control}} for details.  
	}
}
\details{
This function minimizes \eqn{|| W^{\frac{1}{2}}(y-X\alpha) ||^2 + \sum \lambda_j |\alpha_j|}{|| W^{1/2}(y-X\alpha) ||^2 + \sum \lambda[j] |\alpha[j]|} over \eqn{\alpha} by executing \code{coordinate-descent} algorithm.
}
\value{
A list of the following components:
  \item{coefficients}{Solution vector, coefficients \eqn{alpha} which solve the optimization problem.}
  \item{itercd}{Number of iterations required to reach \code{epsilon} tolerance, or \code{maxitcd} if reached first}
  \item{lambda}{The penalty vector}
}
\references{
[1] Donoho, D. L. and Johnstone, I. M. (1995). Adapting to unknown smoothness via wavelet shrinkage. Journal of the American Statistical Association, 90(432):1200–1224.

[2] Friedman, J., Hastie, T., H ̈ofling, H., and Tibshirani, R. (2007). Pathwise coordinate optimization. The Annals of Applied Statistics, 1(2):302–332.

[3] Friedman, J., Hastie, T., and Tibshirani, R. (2010). Regularization paths for generalized linear models via coordinate descent. Journal of statistical software, 33(1):1.
}
\author{
Ela Sienkiewicz
}
\note{
}

\seealso{
}
\examples{
}
\keyword{ glm }
\keyword{ lasso }
\keyword{ big data }% __ONLY ONE__ keyword per line
