\name{bdcg}
\alias{bdcg}
\title{\code{Conjugate gradient} method. }
\description{ 
Method computes the minimization of \eqn{\frac{1}{2}c^T X^TWXc - c^Tb}{1/2c^TX^TWXc -c^Tb} over \eqn{c}. \eqn{X}, \eqn{b} and \eqn{W} are parameters.  \eqn{W} is a diagonal matrix with diagonal \eqn{w}. \eqn{X} is represented by \eqn{x} 
}
\usage{
bdcg(x, w, b, c0 = 0, xtvfun, xvfun, xtxvfun, xtxfun, control = list())
}
\arguments{
  \item{x}{
	data object. It can be a matrix, or a filename in a distributed filesystem.  
	It is never interpreted, but passed to matrix-vector operations.  
	}
  \item{w}{
	vector of weights, numeric and non-negative.
	}
  \item{b}{
	numerical vector, see Description.
	}
  \item{c0}{
	starting value.
	}
  \item{xtvfun}{
	Function executing \eqn{X^TWv}, where x, w and v are passed as arguments. 
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a vector.  
	}
  \item{xvfun}{
	Function executing \eqn{XWv}, where x, w and v are passed as arguments. 
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a vector.  
	}
  \item{xtxvfun}{Function executing \eqn{X^TWXv}, where x, w and v are passed as arguments.  
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a vector.  
	}
  \item{xtxfun}{Function executing \eqn{X^TWX}, where x, w are passed as arguments.  
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a matrix.
	Should only be set if the matrix \eqn{XTWX} fits in memory.
	}
  \item{control}{
	a list of control parameters, epsilon, maxit, etc. 
	See \code{\link{bdglm.control}} for details.  
	}
}
\details{
Function computes the minimization of \eqn{\frac{1}{2}x^T X^TWXx - x^Tb} over \eqn{x}. \eqn{X}, \eqn{b} and \eqn{W} are parameters.
\eqn{W} is a diagonal matrix with diagonal \eqn{w}.
Conjugate gradient is an optimization method developed for solving linear equations problem \eqn{Hc=b}, where \eqn{H} is a symmetric, positive-definite matrix. This problem is equivalent to a quadratic optimization \eqn{\min_x (\frac{1}{2}c^T{H}c - c^Tb)}. The solution is based on conjugate vectors \eqn{d_1,\ldots,d_p} such that \eqn{d_i^THd_j=0}, for \eqn{i \neq j }. Here \eqn{H} is calculated as \eqn{X^TWX}.
}
\value{
A list containing the following component:
  \item{coefficients}{a vector of coefficients, a solution of the optimization problem}
  \item{iter}{number of iterations}
  \item{delta}{coefficient delta in last two iterations}
  \item{converged}{if \code{True} desired tolerance reached, otherwise, maximum iterations reached before the desired tolerance.}
}
\references{
[1] Hestenes, M. R. and Stiefel, E. (1952). Methods of conjugate gradients for solving linear systems, volume 49. NBS.
}
\author{
Ela Sienkiewicz
}
\note{
}

\seealso{
\code{\link{summary.bdglm}}, \code{\link{predict.bdglm}}
\code{\link{glm}} for fitting glm model to traditional data
\code{bigglm} in package \code{biglm} for an alternative to fitting glm model to big data
}
\examples{

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ glm }
\keyword{ big data }
