\name{bdglm-package}
\alias{bdglm-package}
\alias{bdglm}
\docType{package}
\title{Fits glm models to big data}
\description{This package fits maximum likelihood and sparse glm models to various data. The data is only accessed through user-defined matrix-vector operations. The package is suitable to operate on large and distributed data sets.
}
\details{
\tabular{ll}{
Package: \tab bdglm\cr
Type: \tab Package\cr
Version: \tab 0.9 (beta)\cr
Date: \tab 2016-06-07\cr
License: \tab GNU GPL\cr
}
Package 'bdglm' implements functions \code{\link{bdglm.fit}}, \code{\link{bdglm.fit.lasso}}, \code{\link{bdglm.fit.groupbridge}}.
}
\author{
Ela Sienkiewicz

Maintainer: Ela Sienkiewicz <eladsien@gmail.com>
}
\references{
[1] McCullagh P. and Nelder, J. A. (1989) Generalized Linear Models. London: Chapman and Hall.

[2] Tibshirani, R. (1996). Regression shrinkage and selection via the lasso. Journal of the Royal Statistical Society, Series B, 58:267–288.
}
\keyword{ package }
\seealso{
\code{\link{glm}} for fitting glm model to traditional data
\code{bigglm} in package \code{biglm} for an alternative to fitting glm model to big data
}
\examples{
library(bdglm)
y=c(0,0,1,0,0,1,1,1,0,1,1,0,0,1,0,0,1,0,1,0,0,1,1,0,0,1,0,0,1,0,0,1,0)
x1=c(32,45,60,53,25,68,82,38,67,92,72,21,26,40,33,45,61,16,18,22,27,35,40,10,24,15,23,19,22,61,21,32,17)
x2=c(3,2,2,1,4,1,2,5,2,2,3,5,3,4,3,1,2,3,4,6,3,3,3,4,3,4,3,5,2,2,3,5,1)

x=cbind(x1,x2)

dimnames(x)=list(NULL,c("x1","x2"))

# defaults
start=c(0,0,0)
res.bdglm=bdglm.fit(x,y,family=binomial("probit"),start=start,intercept=T, trace=F)
summary(res.bdglm)

xtyfun=function(x,y,weights) {
	x1=cbind(1,x)
	return(t(x1) \%*\% (weights*y))
}

xvfun=function(x, b) {
	if (ncol(x) == length(b)) return (x \%*\% b)
	x1 <- cbind(1,x)
	return ((x1) \%*\% b)
}

xtxvfun=function(x,b,weights) {
	x1 <- cbind(1,x)
	return((t(x1)) \%*\% (weights*x1) \%*\% b)
}

xtxfun=function(x,weights) {
	x1 <- cbind(1,x)
	return(t(x1) \%*\% (weights*x1) )
}

xjfun=function(x,ind) {
	if (ind[1]==1) return(rep(1,nrow(x)))
	if (ind[1] <= ncol(x)+1) return(x[,ind[1]-1])
	return (c(NA))	
}

matfun=list(xtyfun=xtyfun,xvfun=xvfun,xtxvfun=xtxvfun,xtxfun=xtxfun)

res.bdglm=bdglm.fit(x,y,family=binomial("probit"),start=start,matfun=matfun,intercept=T, trace=F)
summary(res.bdglm)
plot(res.bdglm)

matfun=list(xtyfun=xtyfun,xvfun=xvfun,xtxvfun=xtxvfun,xtxfun=xtxfun,xjfun=xjfun)

lambda=c(0,10,2)
res.lasso=bdglm.fit.lasso(x, y, family=binomial("probit"), lambda=lambda, start=res.bdglm$coefficients, 
	matfun=matfun, intercept=T, hasmle=T)

summary(res.lasso)

}
