\name{bdglm.fit.groupbridge}
\alias{bdglm.fit.groupbridge}
\title{Fit regularized sparse glm model, with \code{Group Bridge} penalty.}
\description{
Fits reguarized sparse generalized linear model (glm) to the data. \code{Grup Bridge} penalty is used for regularization. The method is configurable to accomodate distributed data.
}
\usage{
bdglm.fit.groupbridge(x, y, family, weights = NULL, nvar, start, etastart = NULL, mustart = NULL, intercept=T, amat, cvec, gamma = 0.5, tau, matfun = list(), minfun = "bdcg", hasmle = F, control = list(...), ...)
}
\arguments{
  \item{x}{
	data object. It can be a matrix, or a filename in a distributed filesystem.  
	It is never interpreted, but passed to matrix-vector operations.  
	}
  \item{y}{
	response vector. Expected to contain numerical binary data.  
	}
  \item{family}{ 
	glm family defining the type of data and link function. 
	Follows the standard established by \code{\link{glm}}. (
	See \code{\link{family}} for family functions).  
	}
  \item{weights}{
	vector of weights, optional. If set, expected to contain numerical, non-negative data.  
	}
  \item{nvar}{
	number of parameters in the model. Required if the number of parameteres cannot be derived from 
	\code{start} or \code{lambda}. If specified, it should include intercept, if intercept is in the model.  
	}
  \item{amat}{
	matrix with penalty parameters. See [3] for details.  
	}
  \item{cvec}{
	penalty weights. See [3] for details.  
	}
  \item{gamma}{
	penalty parameter, defaults to 0.5. See [3] for details.  
	}
  \item{tau}{
	Penalty value. See [3] for details.  
	}
  \item{start}{
	starting values for the optimization problem. Optional, defaults to 0. 
	The length of the starting vector is assumed to specify the number of parameters in the model.  
	}
  \item{etastart}{
	starting values for linear predictors \eqn{\eta}. 
	For for compatibility with \code{\link{glm}}.  
	}
  \item{mustart}{
	starting values for the response mean \eqn{\mu}. 
	For for compatibility with \code{\link{glm}}.  
	}
  \item{intercept}{
	include the intercept in the model.  
	}
  \item{matfun}{
	a list of matrix-vector functions: xtxfun:\eqn{X^TWv},xvfun:\eqn{Xv},xtxvfun:\eqn{X^TWXv}, xtxfun:\eqn{X^TWX}.
	First 3 function take 3 parameters, \code{x} passed as argument to bdglm.fit, 
	vector v and vector w - a diagonal of matrix W. 
	The return is a vector representing the result of the operation. 
	The fouth function takes two parameters: \code{x} and \code{w}, and returns a matrix. 
	The fifth function takes two parameters: \code{x} and \code{j}, and returns a vector.
	representing the j-th column of data matrix.  
	}
  \item{minfun}{
	The method to be used to perform \eqn{L_2} minimization executed in each step of 
	\code{iteratively reweighted least squares}.
	Defaults to conjugate-gradient method \code{\link{bdcg}}.  
	}
  \item{hasmle}{
	if set to \code{True} the start parameter is assumed to represent mle and mle calculation is skipped.  
	}
  \item{control}{
	a list of control parameters, epsilon, maxit, etc. 
	See \code{\link{bdglm.control}} for details.  
	}
}
\details{
}
\value{
\code{bdglm.fit.groupbridge} returns an object of class 'bdglm' which inherits from 'glm'. 
The function \code{\link{summary}} can be called on that object.

An object of class 'bdglm' is a list containing the following components:
  \item{coefficients}{a vector of coefficients}
  \item{residuals}{model residuals}
  \item{fitted.values}{model fitted values}
  \item{rank}{model rank}
  \item{family}{family used to fir the model}
  \item{linear.predictors}{linear predictors}
  \item{null.deviance}{deviance for the null model}
  \item{deviance}{deviance for the fitted model}
  \item{aic}{model Akaike's Information Criterion (AIC)}
  \item{iter}{number of \code{irls} iterations}
  \item{weights}{final weights}
  \item{prior.weights}{original weights}
  \item{df.residual}{degrees of freedom for the fitted model}
  \item{df.null}{degrees of freedom for the null model}
  \item{y}{reponse used}
  \item{x}{data used}
  \item{converged}{if \code{True} desired tolerance reached, otherwise, maximum iterations reached before the desired tolerance.}
  \item{call}{original call}
  \item{formula}{simplified model formula}
  \item{terms}{simplified model terms}
  \item{xtvfun}{used \eqn{X^TWv} function}
  \item{xvfun}{used \eqn{Xv} function}
  \item{xtxvfun}{used \eqn{X^TXWv} function}
}
\references{
[1] McCullagh P. and Nelder, J. A. (1989) Generalized Linear Models. London: Chapman and Hall.

[2] Tibshirani, R. (1996). Regression shrinkage and selection via the lasso. Journal of the Royal Statistical Society, Series B, 58:267–288.

[3] Huang, J., Ma, S., Xie, H., and Zhang, C. (2009). A group bridge approach for variable selection. Biometrika, 2:339–355.

[4] Akaike, H. (1973). Information theory and an extension of the maximum likelihood principle. In Proceeding of the 2nd International Symposium on Information Theory, pages 267–281.
}
\author{
Ela Sienkiewicz
}
\note{
}


\seealso{
\code{\link{glm}} for fitting glm model to traditional data
\code{bigglm} in package \code{biglm} for an alternative to fitting glm model to big data
}
\examples{

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ glm }
