\name{bdglm.irls}
\alias{bdglm.irls}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Execute \code{iteratively reweighted least squares}.}
\description{
Executes \code{iteratively reweighted least squares} to fit generalized linear model (glm) to the data by maximizing the likelihood function. The function is configurable to accomodate distributed data.
}
\usage{
bdglm.irls(x, y, family, weights = rep(1, nobs), start, etastart = NULL, mustart = NULL, intercept, xtvfun, xvfun, xtxvfun, xtxfun,minfun, control)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
	data object. It can be a matrix, or a filename in a distributed filesystem.  
	It is never interpreted, but passed to matrix-vector operations.  
  	}
  \item{y}{
	response vector. Expected to contain numerical binary data.  
  	}
  \item{family}{ 
	glm family defining the type of data and link function. 
	Follows the standard established by \code{\link{glm}}. (See \code{\link{family}} for family functions).  
  	}
  \item{weights}{
	vector of weights, optional. 
	If set, expected to contain numerical, non-negative data.  
  	}
  \item{start}{
	starting values for the optimization problem. 
	Optional, defaults to 0. The length of the starting vector is assumed to specify the number of parameters in the model.  
  	}
  \item{etastart}{
	starting values for linear predictors \eqn{\eta}. 
	Preserved for compatibility with \code{\link{glm}}.  
  	}
  \item{mustart}{
	starting values for the response mean \eqn{\mu}. 
	Preserved for compatibility with \code{\link{glm}}.  
  	}
  \item{intercept}{
	include the intercept in the model.  
  	}
  \item{xtvfun}{
	Function executing \eqn{X^TWv}, where x, w and v are passed as arguments. 
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a vector.  
	}
  \item{xvfun}{
	Function executing \eqn{XWv}, where x, w and v are passed as arguments. 
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a vector.  
	}
  \item{xtxvfun}{Function executing \eqn{X^TWXv}, where x, w and v are passed as arguments.  
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a vector.  
	}
  \item{xtxfun}{Function executing \eqn{X^TWX}, where x, w are passed as arguments.  
	\code{X} is represented by \code{x} and w is a diagonal of \code{W}. 
	The result is returned as a matrix  
	Should only be set if the matrix \eqn{XTWX} fits in memory.
	}
  \item{minfun}{
	The method to be used to perform \eqn{L_2} minimization executed in each step of \code{iteratively reweighted least squares}.
	Defaults to conjugate-gradient method \code{\link{bdcg}}.  
	}
  \item{control}{
	a list of control parameters, epsilon, maxit, etc. See \code{\link{bdglm.control}} for details.  
  }
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
%% ...
  \item{coefficients}{a vector of coefficients}
  \item{residuals}{model residuals}
  \item{fitted.values}{model fitted values}
  \item{rank}{model rank}
  \item{family}{family used to fir the model}
  \item{linear.predictors}{linear predictors}
  \item{null.deviance}{deviance for the null model}
  \item{deviance}{deviance for the fitted model}
  \item{aic}{model Akaike's Information Criterion (AIC)}
  \item{iter}{number of \code{irls} iterations}
  \item{weights}{final weights}
  \item{prior.weights}{original weights}
  \item{df.residual}{degrees of freedom for the fitted model}
  \item{df.null}{degrees of freedom for the null model}
  \item{converged}{if \code{True} desired tolerance reached, otherwise, maximum iterations reached before the desired tolerance.}
  \item{xtvfun}{used \eqn{X^TWv} function}
  \item{xvfun}{used \eqn{Xv} function}
  \item{xtxvfun}{used \eqn{X^TXWv} function}
}
\references{
McCullagh P. and Nelder, J. A. (1989) Generalized Linear Models. London: Chapman and Hall.
Akaike, H. (1973). Information theory and an extension of the maximum likelihood principle. In Proceeding of the 2nd International Symposium on Information Theory, pages 267–281.
}
\author{
Ela Sienkiewicz
}
\note{
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{summary.bdglm}}, \code{\link{predict.bdglm}}
\code{\link{glm}} for fitting glm model to traditional data
\code{bigglm} in package \code{biglm} for an alternative to fitting glm model to big data
}
\examples{

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ glm }
\keyword{ big data }
