.bdmiso.coefs.int.square <-
function(coefs,start,k) {
	arr=matrix(coefs[start:(start+k*k-1)],ncol=k,nrow=k,byrow=T)
	return(arr)
}
.bdmiso.coefs.int.triangle <-
function(coefs,start,s) {
	d=max(s[,2])
	arr=matrix(0,ncol=d,nrow=d)
	for (i in 1:dim(s)[1]) {
		arr[s[i,1],s[i,2]]=coefs[start+i]
	}
	for (j in 1:d) for (i in j:d) if (i<j) arr[i,j]=arr[j,i]
	return(arr)
}
.bdmiso.inttype.flags <-
function(inttypelist) {
	inttype <- 0
        if (any(inttypelist=="xx")) inttype <- bitwOr(inttype, 1)
        if (any(inttypelist=="x2")) inttype <- bitwOr(inttype, 2)
        if (any(inttypelist=="xy")) inttype <- bitwOr(inttype, 4)
        if (any(inttypelist=="y2")) inttype <- bitwOr(inttype, 8)
        if (any(inttypelist=="t2")) inttype <- bitwOr(inttype, 16)
        return(inttype)
}
.bdmiso.matrix.o2.shortcut <-
function(object) {
	p <- object$p
	k <- object$k
	px <- p
	if (object$incy) px <- p-1
	
	s=array(NA,dim=c(p,p))
	l=1
	
	for (i1 in 1:p) for (i2 in i1:p) {
		#s[i1,i2]=l
		if (i1==i2 && i1 <= px) {
			if (any(object$inttype=="x2")) {
				s[i1,i2]=l
				l <- l + k*(k-1)/2
			}
			if (any(object$inttype=="t2")) {
				s[i1,i2]=l
				l <- l + k
			}
		} else if (i1==i2 && i1==p && object$incy){
			if (any(object$inttype=="y2")) {
				s[i1,i2]=l
				l <- l + k*(k-1)/2
			}
			if (any(object$inttype=="t2")) {
				s[i1,i2]=l
				l <- l + k
			}
		}
		else if (i1 < i2 && i2 <= px) {
			if (any(object$inttype=="xx")) {
				s[i1,i2]=l
				l <- l + k^2
			}
		}
		else if (i1 < i2 && i2 == p && object$incy) {
			if (any(object$inttype=="xy")) {
				s[i1,i2]=l
				l <- l + k^2
			}
		}
	}
	sii=array(0,dim=c(k^2,2))
	l=1
	for (k1 in 1:k) for (k2 in k1:k) {
		if (k1!=k2 || any(object$inttype=="t2")) {sii[l,]=c(k1,k2);l=l+1}
	}
	sii=sii[1:(l-1),]
	return(list(s=s,sii=sii))
}
.bdmiso.Xj <- 
function(object, j) {
	
	x <- object$x
	pk=object$p*object$k
	
	jorig=j
	if (j==1 && object$intercept) {return (cbind(rep(1,object$n)))}
	if (object$intercept) j <- j-1
	
	if (j <= pk) {return (object$x[,j])}
	
	j <- j - pk
	
	smato2 <- object$smato2
	
	if (is.null(smato2)) {
		smato2 <- .bdmiso.matrix.o2.shortcut(object)
	}
	for (i1 in object$p:1) for (i2 in (object$p):i1) {
		if (is.na(smato2$s[i1,i2])) next
		if (smato2$s[i1,i2]>j) next;
		d <- j-smato2$s[i1,i2]+1
		if (i1==i2) 
			xind <- smato2$sii[d,] else {
			xind <- c(as.integer(d/(object$k))+1, d %%(object$k))
			if (xind[2]==0) xind=xind+c(-1,object$k)
		}
				
		xind <- xind+c(object$k*(i1-1),object$k*(i2-1))

		if (length(xind)<2 || any(is.na(xind)) || any(is.null(xind)) || any(xind>pk)) 
			return (c(NA))
		return (x[,xind[1]]*x[,xind[2]])
	}
	return(c(NA))
}
.bdmiso.Xtv <-
function(object, y, weights)
{
	p2 <- miso.pdim.o1(object) + miso.pdim.o2(object) + ifelse(object$intercept,1,0)
	res <- rep(0,p2)

	inttype <- .bdmiso.inttype.flags(object$inttype)

	out=.C("Xty", nxp=as.integer(object$n), pxp=as.integer(object$p), kxp=as.integer(object$k),
	interceptp=as.integer(object$intercept),incyp=as.integer(object$incy), inttypep=as.integer(inttype),
	xmat=as.double(t(object$x)), yvec=as.double(y*weights), res=as.double(res))

	vec <- cbind(out$res)
	return(vec)
}
.bdmiso.XtWX <-
function(object, weights)
{
	p2 <- miso.pdim.o1(object) + miso.pdim.o2(object) + ifelse(object$intercept,1,0)
	res <- rep(0,p2*p2)

	inttype <- .bdmiso.inttype.flags(object$inttype)

	out=.C("XtWX", nxp=as.integer(object$n), pxp=as.integer(object$p), kxp=as.integer(object$k),
	interceptp=as.integer(object$intercept),incyp=as.integer(object$incy), inttypep=as.integer(inttype),
	xmat=as.double(t(object$x)), wts=as.double(weights), res=as.double(res))

	vec <- matrix(out$res,nrow=p2,ncol=p2,byrow=T)
	return(vec)
}
.bdmiso.XtWXv <-
function(object, y, weights)
{
	p2 <- miso.pdim.o1(object) + miso.pdim.o2(object) + ifelse(object$intercept,1,0)
	res <- rep(0,p2)

	inttype <- .bdmiso.inttype.flags(object$inttype)

	out=.C("XtWXy", nxp=as.integer(object$n), pxp=as.integer(object$p), kxp=as.integer(object$k),
	interceptp=as.integer(object$intercept),incyp=as.integer(object$incy), inttypep=as.integer(inttype),
	xmat=as.double(t(object$x)), wts=as.double(weights), yvec=as.double(y), res=as.double(res))

	vec <- cbind(out$res)
	return(vec)
}
.bdmiso.Xv <-
function(object, y)
{
	if (class(object) == "matrix") return (object %*% y)
	res <- rep(0,object$n)

	inttype <- .bdmiso.inttype.flags(object$inttype)

	out=.C("Xxy", nxp=as.integer(object$n), pxp=as.integer(object$p), kxp=as.integer(object$k),
	interceptp=as.integer(object$intercept),incyp=as.integer(object$incy), inttypep=as.integer(inttype),
	xmat=as.double(t(object$x)), yvec=as.double(y), res=as.double(res))

	vec <- cbind(out$res)
	return(vec)
}
