miso.bspl.matrix.o1 <-
function(spikes,mem,knots,degree=3,output.index=NA, d=1,sintercept=T) {
        n <- dim(spikes)[1]
        p <- dim(spikes)[2]

        k <- length(knots)+degree+ifelse(sintercept,1,0)
        off <- 0

        x <- array(0,dim=c(n-mem+1,p*k))

        for (i in 1:p) {
                if (!is.na(output.index) && i==output.index) off=1

                for (s in ((mem+off):n))  {

                        trange=c((s-mem+1-off):(s-off))
                        vals=(s-off)*d-spikes[trange,i]
                        vals=sort(vals[!is.na(vals)])
                        vals=c(0,vals,mem*d)

                        if (length(vals)==0) {ints=rep(0,k)} else {
                                bspl=bs(vals, knots=knots,degree=degree,intercept=sintercept);
                                bspl=bspl[-c(1,dim(bspl)[1]),]
                                if (is.null(dim(bspl))) {ints=bspl} else {ints=apply(bspl,2,sum)}
                        }
                        x[s-mem+1,(((i-1)*k+1):(i*k))]=ints
                }
        }

	res=list(x=x,p=p,k=k,n=dim(x)[1],incy=!is.na(output.index),sintercept=sintercept,mem=mem,degree=degree)
        class(res)="bdmiso"
        return(res)
}
