miso.coefficients.o2 <-
function(object) {
	coefs <- object$coefficients
	
	if (is.null(coefs)) stop("object has no coefficients")
	
	mobj <- object$miso

	if (is.null(mobj)) stop("object has no miso model component")
	
	smato2 <- mobj$smato2
	
	if (is.null(smato2)) {
		smato2 <- .bdmiso.matrix.o2.shortcut(mobj)
	}
	
	coefs0 <- matrix(object$coefficients[2:(mobj$p*mobj$k+1)],nrow=mobj$p,byrow=T)
	res=list(coefs0=coefs0)

	for (i1 in 1:mobj$p) for (i2 in 1:mobj$p) {
		if (is.na(smato2$s[i1,i2])) next
		if (i1==i2) {
			coefs <- .bdmiso.coefs.int.triangle(object$coefficients,smato2$s[i1,i2],smato2$sii) 
		}
		else {
			coefs <- .bdmiso.coefs.int.square(object$coefficients,smato2$s[i1,i2],mobj$k)
		}
		name=paste("coefs",i1,i2,sep="")
		res[[name]]=coefs
	}
	return(res)	
}
