miso.glm.probit.groupbridge.o1 <-
function(object, y, start=NULL, hasmle=F,
	amat,c,gamma=0.5,tau, 
	control=list(...),...) {
   control <- do.call("bdglm.control",control)

   if (is.null(start)) start=rep(0,dim(object$x)[2]+1)

   res <- bdglm.fit.groupbridge(object$x,y,family=binomial("probit"),
      nvar=dim(object$x)[2]+1,  
      start=start, intercept=T,
      hasmle=hasmle,
      amat=amat,cvec=c,gamma=gamma,tau=tau,
      control=control)
   res$miso <- object
   class(res) <- c("bdmisoglm",class(res))

   return(res)
}

