miso.glm.probit.groupbridge.o2 <-
function(object,y,start=NULL, hasmle=F,
   amat,c,gamma,tau=0.5, control=list(...),...) {
   control <- do.call("bdglm.control",control)
   
   p = miso.pdim.o1(object) + miso.pdim.o2(object) + 1
   if (is.null(start)) start=rep(0,p)

   matfun <- list(xtvfun=.bdmiso.Xtv, xvfun=.bdmiso.Xv, xtxvfun=.bdmiso.XtWXv, 
	xtxfun=.bdmiso.XtWX, xjfun=.bdmiso.Xj)
   if (!object$squaremat) matfun$xtxfun=NULL
	
   res <- bdglm.fit.groupbridge(object,y,family=binomial("probit"),
      nvar=p,start=start,intercept=T,
      matfun=matfun,
      amat=amat,cvec=c,gamma=gamma,tau=tau,
      hasmle=hasmle,control=control)
   res$miso <- object
   class(res) <- c("bdmisoglm",class(res))
   return(res)
}

