miso.glm.probit.lasso.o2 <-
function(object,y,lambda, start=NULL, hasmle=F,control=list(...), ...) {
   control <- do.call("bdglm.control",control)

   p = miso.pdim.o1(object) + miso.pdim.o2(object) + 1
   if (is.null(start)) start=rep(0,p)

   matfun <- list(xtvfun=.bdmiso.Xtv, xvfun=.bdmiso.Xv, xtxvfun=.bdmiso.XtWXv, 
	xtxfun=.bdmiso.XtWX, xjfun=.bdmiso.Xj)
   if (!object$squaremat) matfun$xtxfun=NULL

   res <- bdglm.fit.lasso(object,y,family=binomial("probit"),nvar=p, lambda=lambda,
      start=start, intercept=T, matfun=matfun,
      hasmle=hasmle, control=control)
   res$miso <- object
   class(res) <- c("bdmisoglm",class(res))
   return(res)
}

