miso.glm.probit.o2 <-
function(object,y,control=list(...),...) {
   control <- do.call("bdglm.control",control)

   p = miso.pdim.o1(object) + miso.pdim.o2(object) + 1
   start=rep(0,p)

   matfun <- list(xtvfun=.bdmiso.Xtv, xvfun=.bdmiso.Xv, xtxvfun=.bdmiso.XtWXv, 
	xtxfun=.bdmiso.XtWX, xjfun=.bdmiso.Xj)
   if (!object$squaremat) matfun$xtxfun=NULL

   res <- bdglm.fit(object,y,family=binomial("probit"),start=start,intercept=T,
      matfun=matfun,control=control)
   res$miso <- object
   class(res) <- c("bdmisoglm",class(res))

   return(res)
}
