miso.neuro.spikes <-
function(times20MHz,clusters=NULL,
    timeticks, exclude=c(0),
	type=c("time")) {

	if (is.null(times20MHz) || length(times20MHz) < 2) 
		stop("times in 20Mhz clock not specified")

	if (!is.null(clusters) && length(clusters) != length(times20MHz))
		stop("Lengths of times and clusters don't match")
		
	if (is.null(timeticks) || length(timeticks) < 2) 
		stop("time ticks not specified")
		
	ts <- times20MHz*0.05
	
	for (e in exclude) ts <- ts[clusters != e]
	
	return (miso.spikes(ts,timeticks,type))
	
}
