\name{miso.bspl.matrix.o1}
\alias{miso.bspl.matrix.o1}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Generate first order matrix for the multipl-input single-output model with memory.
}
\description{
This function generates a model matrix for the spike data, based on the b-spline approximation of the kernel functions.
}
\usage{
miso.bspl.matrix.o1(spikes, mem, knots, degree = 3, output.index = NA, d = 1, sintercept = T)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{spikes}{
	A matrix of time data generated for each input by function \code{\link{miso.neuro.spikes}} or \code{\link{miso.spikes}}.
%%     ~~Describe \code{spikes} here~~
}
  \item{mem}{
	System memory specified in he same units as the time data in spikes. Assumed milliseconds.
}
  \item{knots}{
	Knots to be used in the b-spline approximation.
}
  \item{degree}{
	Spline degree to be used in the b-spline approximation, defaults to 3 (cubic splines).
}
  \item{output.index}{
	Autoregressive component is included in the model, and corresponds to column output.index in the spikes data.
}
  \item{d}{
	The size of bin to use for the matrix generation, defaults to 1ms. Each row of generated matrix will correspond to subsequent 1ms time blocks.
}
  \item{sintercept}{
	Include interecpt in b-spline approximation. Defaults to \code{True}.
}
}
\details{
}
\value{
Object of class \code{bdmiso} describing the model:
  \item{x}{
	First order matrix copied from parameters.
	}
  \item{n}{
	Number of rows of x.
	}
  \item{p}{
	Number of inputs in the system.
	}
  \item{k}{
	Number of columns corresponding to each input .
	}
  \item{degree}{
	Spline function degree used.
	}
  \item{intercept}{
	Model has intercept.
	}
}
\references{
}
\author{
Ela Sienkiewicz
}
\note{
}


\seealso{
}
\examples{
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
