\name{miso.config}
\alias{miso.config}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Create a configuration object for miso model fit
}
\description{
This function creates a configuration object that is required by all subsequent miso calls.
It describes the size and composition of the first order matrix.
}
\usage{
miso.config(x, inputs, intercept = T, incy = T, degree = 3, inttype = c("xx", "x2"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
	First order matrix.
	}
  \item{inputs}{
	Number of inputs in the model
	}
  \item{intercept}{
	Include intercept in the model
	}
  \item{incy}{
	Include the autoregressive component
	}
  \item{degree}{
	Spline degree if splines used
	}
  \item{inttype}{
	Type of interactions to be included in teh second order model.
	}
}
\details{
A single input consists of observations in t1,..,tN. There is also a potential autoregressive component y in the model.
The parameter inttype can contain the following:
xx indicates interactions between inputs.
x2 indicates interactions between a single input at different timelags.
xy indicates interactions between inputs and an autoregressive component y
y2 indicates interactions between different timelags of the autoregressive component
t2 indicates interactions between inputs and outputs at the same timelag (requires that x2 and y2 are spcified too)
}
\value{
Object of class \code{bdmiso} describing the model:
  \item{x}{
	First order matrix copied from parameters.
	}
  \item{n}{
	Number of rows of x.
	}
  \item{p}{
	Number of inputs in the system.
	}
  \item{k}{
	Number of columns corresponding to each input .
	}
  \item{degree}{
	Spline function degree used.
	}
  \item{intercept}{
	Model has intercept.
	}
  \item{incy}{
	Autoregressive component used in the model.
	}
  \item{inttype}{
	Type of interactions included in the model (see Details).
	}
}
\references{
}
\author{
Ela Sienkiewicz
}
\note{
}


\seealso{
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
