\name{miso.glm.probit.o1}
\alias{miso.glm.probit.o1}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
First order maximum likelihood probit model fit.
%%  ~~function to do ... ~~
}
\description{
This function fits the first order maximum likelihood  generalized linear model with probit family to the binary data.
}
\usage{
miso.glm.probit.o1(object, y, control = list(...), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
	Object of class 'bdmiso' created by a call to \code{miso.bspl.matrix.o1} or \code{miso.config.R}.
}
  \item{y}{
	Response vector 
}
  \item{start}{
	Starting parameter value
}
  \item{control}{
	Control parameters for algorith execution.
}
}
\details{
}
\value{
An object of class 'bdmisoglm' which inherits from 'bdglm':
  \item{coefficients}{a vector of coefficients}
  \item{residuals}{model residuals}
  \item{fitted.values}{model fitted values}
  \item{rank}{model rank}
  \item{family}{family used to fir the model}
  \item{linear.predictors}{linear predictors}
  \item{null.deviance}{deviance for the null model}
  \item{deviance}{deviance for the fitted model}
  \item{aic}{model Akaike's Information Criterion (AIC)}
  \item{iter}{number of \code{irls} iterations}
  \item{weights}{final weights}
  \item{prior.weights}{original weights}
  \item{df.residual}{degrees of freedom for the fitted model}
  \item{df.null}{degrees of freedom for the null model}
  \item{y}{reponse used}
  \item{x}{data used}
  \item{converged}{if \code{True} desired tolerance reached, otherwise, maximum iterations reached before the desired tolerance.}
  \item{call}{original call}
  \item{formula}{simplified model formula}
  \item{terms}{simplified model terms}
  \item{xtvfun}{used \eqn{X^TWv} function}
  \item{xvfun}{used \eqn{Xv} function}
  \item{xtxvfun}{used \eqn{X^TXWv} function}
}
\references{
[1] McCullagh P. and Nelder, J. A. (1989) Generalized Linear Models. London: Chapman and Hall.

[2] Akaike, H. (1973). Information theory and an extension of the maximum likelihood principle. In Proceeding of the 2nd International Symposium on Information Theory, pages 267–281.
}
\author{
Ela Sienkiewicz
}
\note{
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
library(splines)
library(bdglm)
library(bdmiso)

# download these files from www.crcns.org
ns1=read.table("ec016.582.res.1", header=F)[,1]
ns2=read.table("ec016.582.res.2", header=F)[,1]
ns3=read.table("ec016.582.res.3", header=F)[,1]
ns4=read.table("ec016.582.res.4", header=F)[,1]
ns5=read.table("ec016.582.res.5", header=F)[,1]
ns6=read.table("ec016.582.res.6", header=F)[,1]
ns7=read.table("ec016.582.res.7", header=F)[,1]
ns8=read.table("ec016.582.res.8", header=F)[,1]

cl1=read.table("ec016.582.clu.1", header=F)[-1,1]
cl2=read.table("ec016.582.clu.2", header=F)[-1,1]
cl3=read.table("ec016.582.clu.3", header=F)[-1,1]
cl4=read.table("ec016.582.clu.4", header=F)[-1,1]
cl5=read.table("ec016.582.clu.5", header=F)[-1,1]
cl6=read.table("ec016.582.clu.6", header=F)[-1,1]
cl7=read.table("ec016.582.clu.7", header=F)[-1,1]
cl8=read.table("ec016.582.clu.8", header=F)[-1,1]

M=400 # system memory
d=1   # granularity
ninput=8
tt=seq(0, 9*600*1000,by=1)  # timeticks 90min

spiketrain=data.frame(miso.neuro.spikes(ns1,cl1,tt), 	
	miso.neuro.spikes(ns2,cl2,tt),
	miso.neuro.spikes(ns3,cl3,tt),
	miso.neuro.spikes(ns4,cl4,tt),
	miso.neuro.spikes(ns5,cl5,tt),
	miso.neuro.spikes(ns6,cl6,tt),
	miso.neuro.spikes(ns7,cl7,tt),
	miso.neuro.spikes(ns8,cl8,tt))
names(spiketrain)=paste("x",1:ninput,sep="")

knots1=seq(0,M,len=10)[-c(1,10)]
knots2=seq(0,knots1[1],len=5)[-c(1,5)]
knots=c(knots2,knots1)

model.o1=miso.bspl.matrix.o1(spiketrain,M,knots,output.index=ninput)

y=as.numeric(miso.neuro.spikes(ns8,cl8,tt,type="binary")[-c(1:(M-1))])

# mle o1 ----------------------------------------
model.mle.1=miso.glm.probit.o1(model.o1, y)
alpha.mle.1=miso.coefficients.o1(model.mle.1)

px=seq(0,M,len=1000)
pspl=bs(px, knots=knots,intercept=T)

plot(px, pspl \%*\% alpha.mle.1[1,], type="n", xlab="x", ylab=expression(kappa), xlim=c(0,M))
for (i in 1:ninput) lines(px, pspl \%*\% alpha.mle.1[i,], col=i)
legend("topright", legend=as.character(1:ninput), col=1:ninput, lty=rep(1,ninput))
abline(h=0,col="grey", lty=2)

# lasso o1 --------------------------------

lambda=40  # penalty parameter
model.lasso.1=miso.glm.probit.lasso.o1(model.o1,y,lambda=lambda, start=model.mle.1$coefficients, hasmle=T, maxitcd=5)
alpha.lasso.1=miso.coefficients.o1(model.lasso.1)

plot(px, pspl \%*\% alpha.lasso.1[1,], type="n", xlab="x", ylab=expression(kappa), xlim=c(0,M))
for (i in 1:ninput) lines(px, pspl \%*\% alpha.lasso.1[i,], col=i)
legend("topright", legend=as.character(1:ninput), col=1:ninput, lty=rep(1,ninput))
abline(h=0,col="grey", lty=2)


# group bridge o1 --------------------------------
penmat=miso.bspl.groupbridge.penmat.o1(model.o1)
penweights= miso.groupbridge.weights(penmat)

lambda=40
gamma=0.5
tau=lambda^(1/(1-gamma))*gamma^(gamma/(1-gamma))*(1-gamma)
model.gb.1=miso.glm.probit.groupbridge.o1(
	model.o1,y,start=model.mle.1$coefficients, hasmle=T,
	amat=penmat,c=penweights,gamma=0.5,tau=tau, maxitcd=10)

alpha.gb.1=miso.coefficients.o1(model.gb.1)

plot(px, pspl \%*\% alpha.gb.1[1,], type="n", xlab="x", ylab=expression(kappa), xlim=c(0,M))
for (i in 1:ninput) lines(px, pspl \%*\% alpha.gb.1[i,], col=i)
legend("topright", legend=as.character(1:ninput), col=1:ninput, lty=rep(1,ninput))
abline(h=0,col="grey", lty=2)



# mle o2 ----------------------------------------
model.o2 <- miso.config(model.o1$x,model.o1$p,intercept=T,incy=T,inttype=c("xx","x2"))
model.mle.2 <- miso.glm.probit.o2(model.o2, y)

coefs.o2=miso.coefficients.o2(model.mle.2)
alpha.mle.2=coefs.o2$coefs0
plot(px, pspl \%*\% alpha.mle.2[1,], type="n", xlab="x", ylab=expression(kappa), xlim=c(0,M))
for (i in 1:ninput) lines(px, pspl \%*\% alpha.mle.2[i,], col=i)
legend("topright", legend=as.character(1:ninput), col=1:ninput, lty=rep(1,input))
abline(h=0,col="grey", lty=2)

penmat2=miso.bspl.groupbridge.penmat.o2(model.o2)
penweights2= miso.groupbridge.weights(penmat2)

lambda=50
gamma=0.5
tau=lambda^(1/(1-gamma))*gamma^(gamma/(1-gamma))*(1-gamma)
model.gb.2=miso.glm.probit.groupbridge.o2(model.o2,y,amat=penmat2,c=penweights2,gamma=0.5,tau=tau,
	start=model.mle.2$coefficients,hasmle=T)
alpha.gb.2=miso.coefficients.o2(model.gb.2)

plot(px, pspl \%*\% alpha.gb.2[1,], type="n", xlab="x", ylab=expression(kappa), xlim=c(0,M))
for (i in 1:ninput) lines(px, pspl \%*\% alpha.gb.2[i,], col=i)
legend("topright", legend=as.character(1:ninput), col=1:ninput, lty=rep(1,input))
abline(h=0,col="grey", lty=2)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
