\name{miso.neuro.spikes}
\alias{miso.neuro.spikes}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Convert a vector of neural spike times into a binary or time array.
}
\description{
Converts spike times measured with 20MHz clock into an array of binary data or times according to an array of timeticks.
}
\usage{
miso.neuro.spikes(times20MHz, clusters = NULL, timeticks, exclude = c(0), type = c("time"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{times20MHz}{
	A vector of spike times, each assumed to be measured with 20Mhz clock.
}
  \item{clusters}{
	A vector of cluster identifications corresponding to spike times. Usually 0 indicates an error and may be excluded from analysis..
}
  \item{timeticks}{
	An array of timeticks to drive the generation of binary or double data.
}
  \item{exclude}{
	Clustering values to exclude.
}
  \item{type}{
	Binary or time data to output.
}
}
\details{
}
\value{
A vector with size equal to timeticks. If 'binary' type selected, the vector contains 0/1 data. If 'time' selected, the vector contains exact time of an event registered within the time bin specified by timeticks, and NA if none specified.
}
\references{
}
\author{
Ela Sienkiewicz
}
\note{
}


\seealso{
}
\examples{
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
